////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@protocol NotificationRegistrationDelegate;
@class OrchestrationUser;

/**
 * A {@link NotificationRegistrationParams} object provides parameters to register for push notifications.
 */

NS_REFINED_FOR_SWIFT
@interface NotificationRegistrationParams : NSObject

/**
 * User identifier used when registering for push notifications.
 */
@property (nonatomic, strong) OrchestrationUser * orchestrationUser;

/**
 * Notification identifier used when registering for push notifications.
 */
@property (nonatomic, copy) NSString * notificationIdentifier;

/**
 * {@link NotificationRegistrationDelegate} to be notified about notification registration events.
 */
@property (nonatomic, weak) id<NotificationRegistrationDelegate> notificationRegistrationDelegate;
@end

NS_ASSUME_NONNULL_END
